const { TranslationServiceClient } = require("@google-cloud/translate").v3;
const path = require("path");
require("dotenv").config();
// Initialize client
const client = new TranslationServiceClient();

// Your Google Cloud Project ID
const projectId = process.env.GOOGLE_CLOUD_PROJECT;
// 🔁 Replace this
const location = "global"; // or use 'us-central1' if needed

async function translateText(text, targetLang) {
  if (!text) return "";
  const request = {
    parent: `projects/${projectId}/locations/${location}`,
    contents: [text],
    mimeType: "text/plain",
    sourceLanguageCode: "en",
    targetLanguageCode: targetLang,
  };
  try {
    const [response] = await client.translateText(request);
    return response.translations[0].translatedText;
  } catch (err) {
    console.error("Translation error:", err.message);
    return text;
  }
}
module.exports = { translateText };
