const db = require("../db/db");

const getAllGallery = () => {
  const sql = `SELECT * FROM gallery`;
  return new Promise((resolve, reject) => {
    db.query(sql, (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

const addGalleryImages = (images) => {
  // images is an array of { filename }
  const sql = `INSERT INTO gallery (Image) VALUES ?`;

  // Prepare the values array like: [[filename1], [filename2], ...]
  const values = images.map((img) => [img.filename]);

  return new Promise((resolve, reject) => {
    db.query(sql, [values], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

const deleteImage = (idGallery) => {
  const sql = `DELETE FROM gallery WHERE idGallery = ?`;
  return new Promise((resolve, reject) => {
    db.query(sql, [idGallery], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

module.exports = {
  getAllGallery,
  addGalleryImages,
  deleteImage,
};
