const db = require("../db/db");
const getAllContacts = () => {
  const sql = `SELECT * FROM contactus`;
  return new Promise((resolve, reject) => {
    db.query(sql, (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

const addContactus = (Name, Email, Phone, Message) => {
  const sql = `INSERT INTO contactus (Name, Email, Phone, Message) VALUES (?,?,?,?)`;
  return new Promise((resolve, reject) => {
    db.query(sql, [Name, Email, Phone, Message], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};
const getbyid = (idContactus) => {
  const sql = `SELECT * FROM contactus WHERE idContactus = ?`;
  return new Promise((resolve, reject) => {
    db.query(sql, [idContactus], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

const deletecontactus = (idContactus) => {
  const sql = `DELETE FROM contactus WHERE idContactus = ?`;
  return new Promise((resolve, reject) => {
    db.query(sql, [idContactus], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

module.exports = {
  getAllContacts,
  addContactus,
  getbyid,
  deletecontactus,
};
