const locationDbService = require("../services/locationDbService");

const addLocation = async (req, res) => {
  try {
    const { Name } = req.body;
    await locationDbService.addLocation(Name);
    res
      .status(201)
      .json({ success: true, message: "Location added successfully!" });
  } catch (err) {
    console.log(err);
    res
      .status(500)
      .json({ message: "Something went wrong when adding location!" });
  }
};

const getAllLocations = async (req, res) => {
  try {
    const data = await locationDbService.getAllLocations();
    res.status(200).json(data);
  } catch (err) {
    console.log(err);
    res
      .status(500)
      .json({ message: "Something went wrong when fetching locations!" });
  }
};

const getLocationById = async (req, res) => {
  try {
    const { idLocations } = req.params;
    const data = await locationDbService.getLocationById(idLocations);
    res.status(200).json(data);
  } catch (err) {
    console.log(err);
    res
      .status(500)
      .json({ message: "Something went wrong when fetching the location!" });
  }
};

const deleteLocation = async (req, res) => {
  try {
    const { idLocations } = req.params;
    await locationDbService.deleteLocation(idLocations);
    res
      .status(200)
      .json({ success: true, message: "Location deleted successfully!" });
  } catch (err) {
    console.log(err);
    res
      .status(500)
      .json({ message: "Something went wrong when deleting location!" });
  }
};

module.exports = {
  addLocation,
  getAllLocations,
  getLocationById,
  deleteLocation,
};
