const accommodationDbService = require("../services/accommodationDbService");

const addAccommodation = async (req, res) => {
  try {
    const { Name, Email, Tel, Link } = req.body;
    const Image = req.file?.filename;

    const add = await accommodationDbService.addAccommodation(
      Name,
      Email,
      Tel,
      Link,
      Image
    );

    res.status(201).json({
      success: true,
      message: "Accommodation added successfully!",
      insertedId: add.insertId,
    });
  } catch (err) {
    console.log(err);
    res
      .status(500)
      .json({ message: "Something went wrong when adding accommodation!" });
  }
};

const getAllAccommodations = async (req, res) => {
  try {
    const data = await accommodationDbService.getAllAccommodations();
    const baseURL = `${req.protocol}://${req.get(
      "host"
    )}/accommodation-upload/`;

    const result = data.map((item) => ({
      ...item,
      Img_url: baseURL + item.Image,
    }));

    res.status(200).json(result);
  } catch (err) {
    console.log(err);
    res
      .status(500)
      .json({ message: "Something went wrong when fetching accommodations!" });
  }
};

const getAccommodationById = async (req, res) => {
  try {
    const { idAccommodation } = req.params;
    const data = await accommodationDbService.getAccommodationById(
      idAccommodation
    );
    const baseURL = `${req.protocol}://${req.get(
      "host"
    )}/accommodation-upload/`;

    const result = {
      ...data[0],
      Img_url: baseURL + data[0].Image,
    };

    res.status(200).json(result);
  } catch (err) {
    res
      .status(500)
      .json({ message: "Something went wrong when fetching accommodation!" });
  }
};

const updateAccommodation = async (req, res) => {
  try {
    const { idAccommodation } = req.params;
    const { Name, Email, Tel, Link } = req.body;
    const Image = req.file?.filename;

    if (Image) {
      await accommodationDbService.updateAccommodationWithImage(
        idAccommodation,
        Name,
        Email,
        Tel,
        Link,
        Image
      );
    } else {
      await accommodationDbService.updateAccommodationWithoutImage(
        idAccommodation,
        Name,
        Email,
        Tel,
        Link
      );
    }

    res
      .status(200)
      .json({ success: true, message: "Accommodation updated successfully!" });
  } catch (err) {
    console.log(err);
    res
      .status(500)
      .json({ message: "Something went wrong when updating accommodation!" });
  }
};

const deleteAccommodation = async (req, res) => {
  try {
    const { idAccommodation } = req.params;

    await accommodationDbService.deleteAccommodation(idAccommodation);
    res.status(200).json({ success: true, message: "Accommodation deleted!" });
  } catch (err) {
    console.log(err);
    res
      .status(500)
      .json({ message: "Something went wrong when deleting accommodation!" });
  }
};

const getAccomadationByLocId = async (req, res) => {
  try {
    const { id } = req.params;

    const baseURL = `${req.protocol}://${req.get(
      "host"
    )}/accommodation-upload/`;

    const data = await accommodationDbService.getAccomadationByLocId(id);
    const result = data.map((item) => ({
      ...item,
      Img_url: baseURL + item.Image,
    }));
    res.status(200).json(result);
  } catch (err) {
    console.log(err);
    res.status(500).json({
      message: "Something went wrong when fetching package category!",
      error: err.message,
    });
  }
};

module.exports = {
  addAccommodation,
  getAllAccommodations,
  getAccommodationById,
  updateAccommodation,
  deleteAccommodation,
  getAccomadationByLocId,
};
