const express = require("express");
const router = express.Router();

const {
  addGalleryImages,
  getAllGallery,
  deleteImage,
  getForDashall,
} = require("../controllers/galleryController");
const uploadMiddleware = require("../middleware/galleryMiddleware");

router.post("/", uploadMiddleware.array("Image", 15), addGalleryImages);
router.get("/", getAllGallery);
router.delete("/:idGallery", deleteImage);
router.get("/get-all-dash", getForDashall);

module.exports = router;
