const videoDbService = require("../services/videoDbService");

const getVideo = async (req, res) => {
  try {
    const data = await videoDbService.getVideo();
    res.status(200).json(data);
  } catch (err) {
    res
      .status(500)
      .json({ message: "Something went wrong when getting video!" });
  }
};

const updateVideo = async (req, res) => {
  try {
    const { id } = req.params;
    const { Link1 } = req.body;
    await videoDbService.updateVideo(id, Link1);
    res.status(200).json({ success: true, message: "updating completed!" });
  } catch (err) {
    console.log(err);
    res
      .status(500)
      .json({ message: "Something went wrong when updating video!" });
  }
};

module.exports = {
  getVideo,
  updateVideo,
};
