const nodemailer = require("nodemailer");
const newsletterDbService = require("../services/newsLetterDbService");

const addNews = async (req, res) => {
  try {
    const { Email } = req.body;

    const transporter = nodemailer.createTransport({
      host: "premium54.web-hosting.com",
      port: 465,
      secure: true,
      auth: {
        user: "newsletter@gammatourz.com",
        pass: ",LAOn}D@F-[f", // Change this if rotated for security
      },
    });

    // Admin notification email
    const mailOptionsAdmin = {
      from: "Gamma Tourz <newsletter@gammatourz.com>",
      to: "newsletter@gammatourz.com",
      subject: "New Newsletter Subscription!",
      text: `New subscriber: ${Email}`,
    };

    // Subscriber thank-you email with Gamma logo and styled layout
    const mailOptionsSubscriber = {
      from: "Gamma Tourz <newsletter@gammatourz.com>",
      to: Email,
      subject: "🎉 Thank You for Subscribing to Gamma Tourz!",
      html: `
        <div style="font-family: Arial, sans-serif; background-color: #f4f4f4; padding: 30px;">
          <div style="max-width: 600px; margin: 0 auto; background-color: #ffffff; border-radius: 10px; overflow: hidden; box-shadow: 0 4px 10px rgba(0,0,0,0.1);">
            
            <!-- Logo -->
            <div style="text-align: center; padding: 20px 0; background-color: #ffffff;">
             <a href="https://gammatourz.com"><img src="https://i.ibb.co/23qWxhXN/gammafoot.png" alt="gammafoot" border="0"></a>
            </div>

            <!-- Header -->
            <div style="background-color: #1e3a8a; padding: 20px; text-align: center;">
              <h1 style="color: #ffffff; margin: 0;">🌍 Gamma Tourz</h1>
              <p style="color: #dbeafe; font-size: 16px;">Your Gateway to Unforgettable Adventures</p>
            </div>

            <!-- Body -->
            <div style="padding: 30px; color: #333333;">
              <h2 style="color: #1e3a8a;">Thank You for Subscribing!</h2>
              <p style="font-size: 16px; line-height: 1.6;">
                Hi there,<br><br>
                We're thrilled to have you as part of our travel community! ✈️🌴<br><br>
                As a subscriber, you'll be among the first to know about exclusive deals, hidden gems, and curated travel tips tailored just for explorers like you.
              </p>
              <p style="font-size: 16px;">
                Get ready to explore breathtaking destinations, unforgettable experiences, and expert travel guides – all delivered straight to your inbox.
              </p>
              <div style="text-align: center; margin-top: 30px;">
                <a href="https://gammatourz.com" style="background-color: #1e3a8a; color: #ffffff; padding: 12px 25px; border-radius: 5px; text-decoration: none; font-size: 16px;">Explore Our Packages</a>
              </div>
              <p style="margin-top: 40px; font-size: 14px; color: #6b7280;">
                Thank you once again for joining us. We can't wait to share our world with you.
              </p>
              <p style="font-size: 14px; color: #6b7280;">
                With love,<br>
                <strong>The Gamma Tourz Team</strong>
              </p>
            </div>

            <!-- Footer -->
            <div style="background-color: #f1f5f9; padding: 20px; text-align: center; font-size: 12px; color: #6b7280;">
              © ${new Date().getFullYear()} Gamma Tourz. All rights reserved.
            </div>
          </div>
        </div>
      `,
    };

    // Send both emails
    await transporter.sendMail(mailOptionsAdmin);
    await transporter.sendMail(mailOptionsSubscriber);

    // Save to DB
    await newsletterDbService.addNews(Email);

    res.status(201).json({
      success: true,
      message: "Subscribed successfully and confirmation email sent!",
    });
  } catch (err) {
    console.error(err);
    res.status(500).json({
      message: "Something went wrong while submitting the request.",
    });
  }
};

const getall = async (req, res) => {
  try {
    const data = await newsletterDbService.getall();
    res.status(201).json(data);
  } catch (err) {
    console.error(err);
    res
      .status(500)
      .json({ message: "Something went wrong while submitting the request." });
  }
};

const deletenews = async (req, res) => {
  try {
    const { idNewsLetter } = req.params;
    await newsletterDbService.deletenews(idNewsLetter);
    res.status(201).json({ success: true, message: "Subscription Deleted!" });
  } catch (err) {
    console.error(err);
    res
      .status(500)
      .json({ message: "Something went wrong while submitting the request." });
  }
};

module.exports = {
  addNews,
  getall,
  deletenews,
};
