const contactusDbService = require("../services/contactusDbService");
const nodemailer = require("nodemailer");
const getAllContact = async (req, res) => {
  try {
    const getAllContacts = await contactusDbService.getAllContacts();
    res.status(201).json(getAllContacts);
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when fetching details!",
      error: err.message,
    });
  }
};

const addContactus = async (req, res) => {
  try {
    const { Name, Email, Phone, Message } = req.body;
    await contactusDbService.addContactus(Name, Email, Phone, Message);
    const transporter = nodemailer.createTransport({
      host: "premium54.web-hosting.com",
      port: 465,
      secure: true,
      auth: {
        user: "newsletter@gammatourz.com",
        pass: ",LAOn}D@F-[f",
      },
    });

    const mailOptions = {
      from: "Gamma Tourz <newsletter@gammatourz.com>",
      to: "inquiries@gammatourz.com",
      subject: "New Contact Us Submission Received",
      text: `You have received a new contact submission:\n\nName: ${Name}\nEmail: ${Email}\nPhone: ${Phone}\nMessage: ${Message}`,
    };

    await transporter.sendMail(mailOptions);
    res.status(201).json({ message: "contactus adding completed!" });
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when adding details!",
      error: err.message,
    });
  }
};

const getbyid = async (req, res) => {
  try {
    const { idContactus } = req.params;
    const data = await contactusDbService.getbyid(idContactus);
    res.status(201).json(data);
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when adding details!",
      error: err.message,
    });
  }
};

const deletecontactus = async (req, res) => {
  try {
    const { idContactus } = req.params;
    await contactusDbService.deletecontactus(idContactus);
    res.status(201).json({ success: true, message: "Deletion completed!" });
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when deleting details!",
      error: err.message,
    });
  }
};
module.exports = {
  getAllContact,
  addContactus,
  getbyid,
  deletecontactus,
};
